# バッチ設計書 16-ci.yml - test job

## 概要

本ドキュメントは、three.jsプロジェクトにおけるGitHub Actions CIワークフローの「test」ジョブの設計仕様を定義する。

### 本バッチの処理概要

GitHub Actionsで実行されるCIワークフローのtestジョブであり、Lint静的解析、単体テスト（core）、単体テスト（addons）、examplesカバレッジチェックを順次実行する統合テストジョブである。

**業務上の目的・背景**：three.jsプロジェクトでは、プルリクエストごとにコード品質と機能の正確性を自動検証する必要がある。このジョブは、ESLintによる静的解析でコーディング規約違反を検出し、QUnitによる単体テストでコアライブラリとアドオンの動作を検証し、カバレッジチェックでexamplesの管理状態を確認する。これにより、リグレッションの早期検出とコード品質の維持を実現する。

**バッチの実行タイミング**：PRイベントでトリガー（build/、docs/、files/ディレクトリの変更は除外）。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. Node.js 24環境のセットアップ
3. npm依存関係のインストール（npm ci）
4. ESLint静的解析の実行（npm run lint）
5. コア単体テストの実行（npm run test-unit）
6. アドオン単体テストの実行（npm run test-unit-addons）
7. examplesカバレッジチェックの実行（npm run test-e2e-cov）

**前後の処理との関連**：e2eジョブと並列実行される。このジョブの成功はPRマージの必須条件。

**影響範囲**：three.jsコアライブラリ（src/）、アドオン（examples/jsm/）、examples管理ファイル。

## バッチ種別

CI/CD / 統合テスト / GitHub Actions ジョブ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | PRごと |
| 実行時刻 | PR作成・更新時 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | pull_request イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub Actions | GitHub Actionsが有効であること |
| ubuntu-latest | ubuntu-latestランナーが使用可能であること |
| Node.js 24 | Node.js 24がインストール可能であること |

### 実行可否判定

- paths-ignore: build/**, docs/**, files/** に該当しない変更であること
- PRが作成または更新されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 自動トリガーのためパラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| リポジトリ全体 | Git | actions/checkout@v6によるチェックアウト |
| package.json | JSONファイル | npm scripts定義 |
| package-lock.json | JSONファイル | npm ci用の依存関係ロックファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions ログ | テキスト | 各ステップの実行結果 |
| PR Status Check | ステータス | ジョブの成功/失敗状態 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. Git checkout
   └─ actions/checkout@v6でリポジトリをチェックアウト

2. Install Node
   └─ actions/setup-node@v6でNode.js 24をセットアップ
   └─ npmキャッシュを有効化

3. Install dependencies
   └─ npm ciで依存関係をインストール

4. Lint testing
   └─ npm run lintでESLint静的解析を実行

5. Unit testing
   └─ npm run test-unitでコア単体テストを実行

6. Unit addons testing
   └─ npm run test-unit-addonsでアドオン単体テストを実行

7. Examples ready for release
   └─ npm run test-e2e-covでカバレッジチェックを実行
```

### フローチャート

```mermaid
flowchart TD
    A[PR作成/更新] --> B{paths-ignore<br>該当?}
    B -->|Yes| C[ジョブスキップ]
    B -->|No| D[testジョブ開始]
    D --> E[Git checkout]
    E --> F[Node.js 24セットアップ]
    F --> G[npm ci]
    G --> H[npm run lint]
    H --> I{Lint成功?}
    I -->|No| J[ジョブ失敗]
    I -->|Yes| K[npm run test-unit]
    K --> L{Unit test成功?}
    L -->|No| J
    L -->|Yes| M[npm run test-unit-addons]
    M --> N{Addons test成功?}
    N -->|No| J
    N -->|Yes| O[npm run test-e2e-cov]
    O --> P{Coverage check成功?}
    P -->|No| J
    P -->|Yes| Q[ジョブ成功]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Lintエラー | ESLintルール違反 | コードを修正して再プッシュ |
| - | 単体テスト失敗 | テストケースが不合格 | テストまたはコードを修正 |
| - | カバレッジエラー | screenshot/files.jsonの不整合 | 不足ファイルを追加 |
| - | npm ciエラー | 依存関係の解決失敗 | package-lock.jsonを更新 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（GitHub Actionsのデフォルト動作） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. GitHub ActionsのUIでエラーログを確認
2. 該当するステップのエラーメッセージに従って修正
3. 修正をコミットしてPRを更新

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ジョブ |
| 目標処理時間 | 5分以内（通常） |
| メモリ使用量上限 | ubuntu-latestランナーの制限内 |

## 排他制御

- 同一PRに対して最新のコミットのみ実行（GitHub Actionsのデフォルト動作）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ステップ開始 | 各ステップ開始時 | ステップ名 |
| コマンド出力 | コマンド実行中 | npm run各コマンドの標準出力/エラー出力 |
| ステップ完了 | 各ステップ完了時 | 実行時間、成功/失敗 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ結果 | 失敗時 | PR Status Check、メール通知（設定による） |

## 備考

- ジョブ名: "Lint, Unit, Unit addons, Circular dependencies & Examples testing"
- Node.js 24を使用（2026年1月時点のLTS）
- npmキャッシュを有効化してインストール時間を短縮
- actions/checkoutとactions/setup-nodeは特定のコミットハッシュを指定（セキュリティ対策）
- permissionsは`contents: read`のみ（最小権限の原則）
